
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

public class ListIteratorView
    extends javax.swing.JFrame
    implements ActionListener
{
    private ListIterator iter;
    private JLabel hasNext;
    private JTextField item;
    Screen screen;
    SLinkedListView listView;
    
    public ListIteratorView( ListIterator i, SLinkedListView v, Screen s)
    {
        super( "ListIterator" );
        iter = i;
        listView=v;
        screen=s;
        this.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e) 
            {
                listView.resumeListView();
            }
        });
	    
        setBackground( Color.lightGray );

        JPanel buttons = new JPanel();

        JButton nextBtn = new JButton( "next" );
        buttons.add( nextBtn );
        nextBtn.addActionListener( this );

        JButton removeBtn = new JButton( "remove" );
        buttons.add( removeBtn );
        removeBtn.addActionListener( this );

        JButton addBtn = new JButton( "add" );
        buttons.add( addBtn );
        addBtn.addActionListener( this );
        
        JButton setBtn = new JButton( "set" );
        buttons.add( setBtn );
        setBtn.addActionListener( this );

        JButton closeBtn = new JButton( "close" );
        buttons.add( closeBtn );
        closeBtn.addActionListener( this );

        getContentPane().add( buttons, BorderLayout.NORTH );

        JPanel nextPanel = new JPanel();

        JLabel nextLabel = new JLabel( " Has Next:" );
        nextPanel.add( nextLabel );

        hasNext = new JLabel( iter.hasNext() ? "TRUE" : "FALSE" );
        nextPanel.add( hasNext );

        JLabel itemLabel = new JLabel( "    Item:" );
        nextPanel.add( itemLabel );

        item = new JTextField( 20 );
        nextPanel.add( item );

        getContentPane().add( nextPanel, BorderLayout.EAST );

        pack();
        setVisible( true );
    }

    public void actionPerformed( ActionEvent e )
    {
        String command = e.getActionCommand();

        if ( command.equals( "close" ) )
            listView.resumeListView();
        else if ( command.equals( "next" ) )
            doNext();
        else if ( command.equals( "remove" ) )
            doRemove();
        else if ( command.equals( "add" ) )
            doAdd();
        else if ( command.equals( "set" ) )
            doSet();
        updateView();
    }
    
    private void doNext()
    {
        try
        {
            String ne=iter.next().toString();
            item.setText(ne);
            listView.updatePosition(ne);
            screen.setK(1);
            screen.startIter(2);
            screen.setDrawMode("drawNumber");
            screen.repaint();
        }
        catch ( NoSuchElementException e )
        {
            Toolkit.getDefaultToolkit().beep();
        }   
    }
    
    private void doRemove()
    {        
        try
        {
            iter.remove();
            item.setText( null );
            updateView();
            listView.updatePosition(null);            
            screen.startIter(3);
            screen.setK(-1);
            screen.setDrawMode("drawNumber");
            screen.repaint();
        }
        catch ( IllegalStateException e )
        {
            Toolkit.getDefaultToolkit().beep();
        }       
    }
    
    private void doAdd()
    {   
       String inp=item.getText();
       item.setText( "" );
       int theInt;
       try
       {
           theInt = Integer.parseInt( inp );
       }
       catch (NumberFormatException e )
       {
           item.setText( "input a number" );
           return;
       }      
       iter.add(new Integer(theInt));
       listView.updatePosition((String)(item.getText()));
       item.setText( null );
       screen.setK(1);
       screen.startIter(2);
       screen.setDrawMode("drawNumber");
       screen.repaint();
        
    }
    
    private void doSet()
    {
        String inp=item.getText();
        int theInt;
        try
        {
            theInt = Integer.parseInt( inp );
        }
        catch (NumberFormatException e )
        {
            item.setText( "input a number" );
            return;
        }
        try
        {
            iter.set( new Integer(theInt) );
            listView.updatePosition(inp);
            updateView();
            screen.setK(0);
            screen.startIter(2);
            screen.setDrawMode("drawNumber");
            screen.repaint();
        }
        catch ( IllegalStateException e )
        {
            Toolkit.getDefaultToolkit().beep();
        }
    }
    
    private void updateView()
    {
        hasNext.setText( iter.hasNext() ? "TRUE" : "FALSE" );
        listView.updateView();
    }
}